"""
A simple maze program.  You are the flashing dot and can walk around
using the accelerometer.
"""

import microbit
from microbit import *
import music

d = microbit.display

# the maze data, as binary numbers (outside walls are added automatically)
maze = [
    0b1111111111111111,
    0b0011110101001001,
    0b1000010101011101,
    0b1110110100000000,
    0b1100000111110111,
    0b1001011101000001,
    0b1011010001011101,
    0b1010000100000101,
    0b1000111111101101,
    0b1010110001000111,
    0b1010000100010001,
    0b1010101111010111,
    0b1010101101010001,
    0b1010100100011101,
    0b1000110111011001,
    0b1111111111111011,
]
def getRockerVal():
    Dir = 0
    val1 = pin1.read_analog()
    val2 = pin2.read_analog()
    if val1 > 750:
        Dir = 1 #up
    elif val1 < 250:
        Dir = 2 #down
    elif val2 < 250:
        Dir = 3 #left
    elif val2 > 750:
        Dir = 4 #right
    print(Dir)
    return Dir

def get_maze(x, y):
    if 0 <= x < 16 and 0 <= y < 16:
        return (maze[y] >> (15 - x)) & 1
    else:
        return 1

def draw(x, y, tick):
    img = microbit.Image(5,5)
    for j in range(5):
        for i in range(5):
            img.set_pixel(i, j, get_maze(x + i - 2, y + j - 2)*5)

    # draw the player, flashing
    img.set_pixel(2, 2, (tick & 1)*4+5)
    d.show(img)

def main():
    x = 0
    y = 1
    tick = 0
    while True:
        dir = getRockerVal()
        tick += 1
        if tick == 4:
            # walk around, with collision detection
            tick = 0
            if dir == 4 and get_maze(x + 1, y) == 0:
                x += 1
            elif dir == 3 and get_maze(x - 1, y) == 0:
                x -= 1
            elif dir == 2 and get_maze(x, y + 1) == 0:
                y += 1
            elif dir == 1 and get_maze(x, y - 1) == 0:
                y -= 1
            x = min(15, max(0, x))
            y = min(15, max(0, y))

        # draw the maze
        draw(x, y, tick)
        microbit.sleep(50)
        
        if (x == 15 and y == 3) or (x==13 and y==15):
            music.play(music.NYAN, pin = pin8)
            x = 0
            y = 1
            tick = 0

main()
