'''
ѭС(PID㷨)
    ʹʱ²
	1PIDkp ki kd
	2ֱٶֵ(Ӱٶ) k_speed 
	3ֵ(ӰתЧ) speedMax
	4ٶȵϵ(Ӱתٶ) speedScale
	5תʱ(Ӱתʱ) turnDelay
'''

from microbit import *
kp = 1
ki = 1
kd = 1
preError = 0
integral = 0
delays = 1
leftMotorSpeed = 0
rightMotorSpeed = 0
k_speed = 50
speedMax = 75
turnDelay = 10

def setLeftMotor(speed):
    i2c.write(0x10, bytearray([0x01, speed]))
    
def setRightMotor(speed): 
    i2c.write(0x10, bytearray([0x02, speed]))

def getSpeed():
    motorSpeed = i2c.read(0x10,4)
    return motorSpeed

def pidInit(kp_ = 0, ki_ = 0, kd_  = 0,delays_ = 1):
    global kp, ki,kd, delays
    kp = kp_
    ki = ki_
    kd = kd_
    delays = delays_
    
def getError():
    err = 0
    varLeft1 = pin1.read_digital()
    varLeft2 = pin14.read_digital()
    varLeft3 = pin13.read_digital()
    varRight1 = pin2.read_digital()
    varRight2 = pin15.read_digital()
    varRight3 = pin16.read_digital()
    if (varLeft1 == 1 and varRight1 == 0 and varLeft2 == 0):
        err = 1
    elif (varLeft2 == 1 and varLeft1 == 1):
        err = 2
    elif (varLeft2 == 1 and varLeft1 == 0 and varLeft3 == 0):
        err = 3
    elif (varLeft3 == 1 and varLeft2 == 1):
        err = 4
    elif (varLeft3 == 1 and varLeft2 == 0):
        err = 5
    elif (varRight1 == 1 and varLeft1 == 0 and varRight2 == 0):
        err = -1
    elif (varRight1 == 1 and varRight2 == 1):
        err = -2
    elif (varRight2 == 1 and varRight1 == 0 and varRight3 == 0):
        err = -3
    elif (varRight3 == 1 and varRight2 == 1):
        err = -4
    elif (varRight3 == 1 and varRight2 == 0):
        err = -5
    #print(err)
    return err

def pidControl():
    global preError,integral,delays,leftMotorSpeed,rightMotorSpeed
    global kd, ki, kd
    
    speedScale = 1
    error = getError()
    if (error != 0):
        speedScale = 2/abs(error)
        if speedScale > 1:
            speedScale = 1
    integral = integral + error
    derivative = error - preError
    output = (int)(kp*error + ki*integral*delays + kd*derivative/delays)
    print(output)
    preError = error
    leftMotorSpeed = int((k_speed - output)*speedScale)
    rightMotorSpeed = int((k_speed + output)*speedScale)

    if leftMotorSpeed < -speedMax:
        leftMotorSpeed = -speedMax
    elif leftMotorSpeed > speedMax:
        leftMotorSpeed = speedMax
    if rightMotorSpeed < -speedMax:
        rightMotorSpeed = -speedMax
    elif rightMotorSpeed > speedMax:
        rightMotorSpeed = speedMax   
    setLeftMotor(leftMotorSpeed)
    setRightMotor(rightMotorSpeed)
    
    sleep(abs(error)*turnDelay)

# test code
pidInit(kp_ = 8, ki_ = 0.0, kd_ = 15, delays_ = 1)
#setLeftMotor(60)
#setRightMotor(60)

while True:
    pidControl()